"""
Regular expression for national telephone numbers.
"""

import re

# American phone number format xxx-xxx-xxxx
phone_en_us = re.compile(r'^[A-PR-Y0-9]{3}-[A-PR-Y0-9]{3}-[A-PR-Y0-9]{4}$', re.IGNORECASE)

# Brazilian phone number format xx-xxxx-xxxx
phone_pt_br = re.compile(r'^[0-9]{2}-[0-9]{4}-[0-9]{4}$', re.IGNORECASE)
