from django.db import models
from django.contrib.auth.models import User

class Vaucher(models.Model):
    issuer = models.ForeignKey(User, related_name='vauchers')
    amount = models.DecimalField(max_digits=6, decimal_places=2, default=0)
    created = models.DateTimeField(auto_now=True, auto_now_add=True)
    applied = models.DateTimeField(auto_now=True, auto_now_add=True)
    agreement = models.ForeignKey('customer.Agreement', related_name='vauchers')

