from django.contrib.auth import models
from django.contrib.contenttypes.models import ContentType

def create_row_perms(type, owner, add=True, change=True, delete=True, negAdd=False, negChange=False, negDel=False):
    ret_dict = {}
    if add:
        add_str = "add_%s" % (ContentType.objects.get_for_model(type))
        ret_dict[add_str]=models.RowLevelPermission.objects.create_row_level_perm(type, owner, add_str, negative=negAdd)
    if change:
        change_str = "change_%s" % (ContentType.objects.get_for_model(type))
        ret_dict[change_str]=models.RowLevelPermission.objects.create_row_level_perm(type, owner, change_str, negative=negChange)
    if delete:
        delete_str = "delete_%s" % (ContentType.objects.get_for_model(type))
        ret_dict[delete_str]=models.RowLevelPermission.objects.create_row_level_perm(type, owner, delete_str, negative=negDel)
    return ret_dict
        
    