"""
34. Row Level Permissions

Row Level Permissions are permissions for a specific instance of an object instead of
all types of an object.
"""

from django.db import models
from django.contrib.contenttypes.models import ContentType
from django.contrib.auth.models import RowLevelPermission, User
from django.contrib.auth import util

class Mineral(models.Model):
    name = models.CharField(maxlength=150)
    hardness = models.PositiveSmallIntegerField()
    
    row_perms = models.GenericRelation(RowLevelPermission, object_id_field="type_id", content_type_field="type_ct")
    
    def __str__(self):
        return self.name
    
API_TESTS = """
#Create default row permissions
>>> from django.contrib.auth.models import RowLevelPermission, Permission, User
>>> from django.contrib.contenttypes.models import ContentType
>>> from django.contrib.auth import util
>>> quartz = Mineral(name="Quartz", hardness=7)
>>> quartz.save()
>>> user = User.objects.create_user('john', 'lennon@thebeatles.com', 'johnpassword')


#>>> util.create_row_perms(quartz, user)
#{'delete_mineral': mineral | Can delete mineral | user:john | mineral:Quartz, 'add_mineral': mineral | Can add mineral | user:john | mineral:Quartz, 'change_mineral': mineral | Can change mineral | user:john | mineral:Quartz}
#>>> quartz.row_perms.all()
#[mineral | Can add mineral | user:john | mineral:Quartz, mineral | Can change mineral | user:john | mineral:Quartz, mineral | Can delete mineral | user:john | mineral:Quartz]
#>>> user.row_perms_owned.all()
#[mineral | Can add mineral | user:john | mineral:Quartz, mineral | Can change mineral | user:john | mineral:Quartz, mineral | Can delete mineral | user:john | mineral:Quartz]

>>> perm = Permission(name="Can mine", codename="mine_mineral", content_type=ContentType.objects.get_for_model(Mineral))
>>> perm.save()
>>> rlp = RowLevelPermission.objects.create_row_level_perm(quartz, user, "mine_mineral")
>>> rlp.owner
<User: john>
>>> rlp.type
<Mineral: Quartz>
>>> rlp.permission
<Permission: mineral | Can mine>
>>> rlp.owner.row_perms_owned.all()
[mineral | Can add mineral | user:john | mineral:Quartz, mineral | Can change mineral | user:john | mineral:Quartz, mineral | Can delete mineral | user:john | mineral:Quartz, mineral | Can mine | user:john | mineral:Quartz]

"""