from django import forms
from django.contrib.contenttypes.models import ContentType
from django.http import Http404, HttpResponse, HttpResponseRedirect
from django.contrib.auth.models import User, Group, Permission, RowLevelPermission

class RLPManipulator(forms.Manipulator):
    def __init__(self, obj_instance, ct):
        self.ct = ct
        self.obj_instance = obj_instance
        owner_list=[('','-- User --')] + [("U"+str(o.id), "User: "+str(o)) for o in User.objects.order_by("username")]
        owner_list.extend([('','-- Group --')] + [("G"+str(o.id), "Group: "+str(o)) for o in Group.objects.order_by("name")])
        perm_list = [('','-- Permission --')] + [(o.id, o.name) for o in self.ct.permission_set.order_by("name")]
        self.fields = (
            forms.SelectField(field_name="owner", choices=owner_list),
            forms.SelectField(field_name="perm", choices=perm_list),            
            forms.CheckboxField(field_name="negative"),                        
            )
    
    def save(self, new_data):
        if new_data['owner'][0] == 'U':
            owner = User.objects.get(pk=new_data['owner'][1:])
        elif new_data['owner'][0] == 'G':
            owner = Group.objects.get(pk=new_data['owner'][1:])
        perm = Permission.objects.get(pk=new_data['perm'])
        
        rlp = RowLevelPermission.objects.create_row_level_perm(self.obj_instance, owner, perm, negative=new_data['negative'])
        return rlp
            
    