r"""
Here are some validator tests - there are plenty more to do!

RequiredIfOtherFieldsNotGiven 
-----------------------------

>>> check(v.RequiredIfOtherFieldsNotGiven(['full1']), '')
'OK'

>>> check(v.RequiredIfOtherFieldsNotGiven(['full1']), 'something')
'OK'

>>> check(v.RequiredIfOtherFieldsNotGiven(['empty1']), '')
'Fail'

>>> check(v.RequiredIfOtherFieldsNotGiven(['empty1']), 'something')
'OK'

>>> check(v.RequiredIfOtherFieldsNotGiven(['full1', 'full2']), '')
'OK'

>>> check(v.RequiredIfOtherFieldsNotGiven(['empty1', 'full2']), '')
'OK'

>>> check(v.RequiredIfOtherFieldsNotGiven(['full1', 'empty2']), '')
'OK'

>>> check(v.RequiredIfOtherFieldsNotGiven(['empty1', 'empty2']), '')
'Fail'

>>> check(v.RequiredIfOtherFieldsNotGiven(['full1', 'full2']), 'something')
'OK'

>>> check(v.RequiredIfOtherFieldsNotGiven(['empty1', 'full2']), 'something')
'OK'

>>> check(v.RequiredIfOtherFieldsNotGiven(['full1', 'empty2']), 'something')
'OK'

>>> check(v.RequiredIfOtherFieldsNotGiven(['empty1', 'empty2']), 'something')
'OK'


RequiredIfOtherFieldNotGiven 
----------------------------

Should work the same as RequiredIfOtherFieldsNotGiven, but with only one 
field name.

>>> check(v.RequiredIfOtherFieldNotGiven('full1'), '')
'OK'

>>> check(v.RequiredIfOtherFieldNotGiven('full1'), 'something')
'OK'

>>> check(v.RequiredIfOtherFieldNotGiven('empty1'), '')
'Fail'

>>> check(v.RequiredIfOtherFieldNotGiven('empty1'), 'something')
'OK'


RequiredIfOtherFieldsGiven
--------------------------

>>> check(v.RequiredIfOtherFieldsGiven(['full1']), '')
'Fail'

>>> check(v.RequiredIfOtherFieldsGiven(['full1']), 'something')
'OK'

>>> check(v.RequiredIfOtherFieldsGiven(['empty1']), '')
'OK'

>>> check(v.RequiredIfOtherFieldsGiven(['empty1']), 'something')
'OK'

>>> check(v.RequiredIfOtherFieldsGiven(['full1', 'full2']), '')
'Fail'

>>> check(v.RequiredIfOtherFieldsGiven(['empty1', 'full2']), '')
'Fail'

>>> check(v.RequiredIfOtherFieldsGiven(['full1', 'empty2']), '')
'Fail'

>>> check(v.RequiredIfOtherFieldsGiven(['empty1', 'empty2']), '')
'OK'

>>> check(v.RequiredIfOtherFieldsGiven(['full1', 'full2']), 'something')
'OK'

>>> check(v.RequiredIfOtherFieldsGiven(['empty1', 'full2']), 'something')
'OK'

>>> check(v.RequiredIfOtherFieldsGiven(['full1', 'empty2']), 'something')
'OK'

>>> check(v.RequiredIfOtherFieldsGiven(['empty1', 'empty2']), 'something')
'OK'


RequiredIfOtherFieldGiven
-------------------------

Just like RequiredIfOtherFieldsGiven, but only works for a single field.

>>> check(v.RequiredIfOtherFieldGiven('full1'), '')
'Fail'

>>> check(v.RequiredIfOtherFieldGiven('full1'), 'something')
'OK'

>>> check(v.RequiredIfOtherFieldGiven('empty1'), '')
'OK'

>>> check(v.RequiredIfOtherFieldGiven('empty1'), 'something')
'OK'

"""

from django.core import validators as v
ALL_DATA = {
        'empty1': '',
        'empty2': '',
        'full1': 'X',
        'full2': 'x',
} 

def check(validator, field_data):
    try:
        validator(field_data, ALL_DATA)
        return 'OK'
    except v.ValidationError:
        return 'Fail'

