from django.db import models

# Create your models here.
class Entry(models.Model):
	title = models.CharField(maxlength=100)
	body = models.TextField()
	
	class Admin:
		list_display = ('title',)
		
	class Meta:
		verbose_name_plural = 'entries'
		
	def __str__(self):
		return self.title
		
	def get_absolute_url(self):
		return "/%i/" % (self.id)