# Demonstrate an issue with the new Django migrations
# and the unique_together setting with foriegn keys.

# Requires that the tip of Django is already installed.

# Die on error
set -e

# Create a new project called 'spam'
django-admin startproject spam

# Go into the new project
cd spam

# Create a new app called 'eggs'
django-admin startapp eggs

# Add the new app to settings.py
cat >> spam/settings.py <<EOF
INSTALLED_APPS = 'eggs',
EOF

# Create the basic failing models
cat > eggs/models.py <<EOF
from django.db import models

class Knight(models.Model):
    pass

class Rabbit(models.Model):
    class Meta:
        unique_together = (('knight', 'parent'),)
    knight = models.ForeignKey(Knight)
    parent = models.ForeignKey('self', related_name='children')
EOF

# Create the migrations
python manage.py makemigrations

# Apply the migrations
python manage.py migrate --no-initial-data
