from models import *
from django.contrib import admin



class AdvisoryAdmin(admin.ModelAdmin):
    def get_readonly_fields(self, request, obj=None):
        return ('last_updated', 'overriden', 'details_html',)

    def get_fieldsets(self, request, obj=None):
        return (
            (None, {
                'fields': (('assigned_to', 'last_updated', 'overriden'),
                            'details_html'
                          )
                    }
            ),
        )

    def details_html(self, obj):
        text = """
<div style="float:left;width:100%">
    <div style="float:left; border: solid 1px red;margin:2px;">CHANGELOG</div>&nbsp;
    <div style="float:left; border: solid 1px red;margin:2px;">COMMITS</div>&nbsp;

    <div style="float:left; border: solid 1px red;margin:2px;">BUGS</div>&nbsp;

    <div style="float:left; border: solid 1px red;margin:2px;">API DIFF</div>&nbsp;
    <div style="float:left; border: solid 1px red;margin:2px;">DIFF</div>&nbsp;



    <div style="float:left; border: solid 1px red;margin:2px;">MORE TESTS</div>&nbsp;

<br /><br />
The divs above should all appear on the same line!
</div>
"""
#        text = text.replace("\n", "")
        return text
    details_html.allow_tags = True
    details_html.short_description = ''

admin.site.register(Advisory, AdvisoryAdmin)
