import exceptions
import math
###################
# EXTRA FILTERS   #
###################
@register.filter
@stringfilter
def reverseString(value):
    """
    Reverse the string from the given string
    """
    safe = isinstance(value, SafeData)
    value = value[::-1]
    if safe :
        return mark_safe(value)
    return value

@register.filter
@stringfilter
def trim(value):
    """
    Removes all blank values from the given string.
    """
    safe = isinstance(value, SafeData)
    value = value.replace(' ', '')
    if safe :
        return mark_safe(value)
    return value

@register.filter
@stringfilter
def ParseInt(value,arg=None):
    """
    Parse a string to int and the value of arg is for error message.
    """
    safe = isinstance(value, SafeData)
    try:
    	value = int(value)
    except exceptions.ValueError:
    	if(arg is None or arg==""):
    		value = "Value-Error"
		else:
			value = arg

    if safe and arg != ';':
        return mark_safe(value)
    return value

@register.filter
@stringfilter
def endsWith(value,arg=None):
    """
    Returns a boolean if the string ends with a patner.
    """
    safe = isinstance(value, SafeData)
    if(arg is None):
    	value = False
    else:
		value = value.__str__().endswith(arg)
    if safe and arg != ';':
        return mark_safe(value)
    return value

@register.filter
@stringfilter
def starstWith(value,arg=None):
    """
    Returns a boolean if the string strats with a patner.
    """
    safe = isinstance(value, SafeData)
    if(arg is None):
    	value = False
    else:
		value = value.__str__().startswith(arg)
    if safe and arg != ';':
        return mark_safe(value)
    return value

@register.filter
@stringfilter
def toLowerCase(value):
    """
    Converts the string to Lower case.
    """
    safe = isinstance(value, SafeData)
    try:
    	value = value.__str__().lower()
	except:
		value = "error"
    if safe:
        return mark_safe(value)
    return value

@register.filter
@stringfilter
def toUpperCase(value):
    """
    Converts the String to Upper Case.
    """
    safe = isinstance(value, SafeData)
    try:
    	value = value.__str__().upper()
	except:
		value = "error"
    if safe:
        return mark_safe(value)
    return value

@register.filter
@stringfilter
def arrayMin(value):
    """
    Return the lowest value element of a array.
    """
    safe = isinstance(value, SafeData)
    try:
    	value = min(value)
    except:
    	value = "error"
    if safe:
        return mark_safe(value)
    return value

@register.filter
@stringfilter
def arrayMax(value):
    """
    Return the highest value element of a array.
    """
    safe = isinstance(value, SafeData)
    try:
    	value = max(value)
	except:
		value = "error"
    if safe:
        return mark_safe(value)
    return value

@register.filter
def exp(value):
    """
    Return the exponential value of the constant e and the given value,(e.g.: pow(e,value), e^value).
    """
    safe = isinstance(value, SafeData)
    try:
    	value = math.exp(value)
    except:
    	value = "error"
    if safe and arg != ';':
        return mark_safe(value)
    return value

@register.filter
def pow(value,arg):
    """
    Return the exponential value of the value with the given arg.
    """
    safe = isinstance(value, SafeData)
    try:
    	value = math.pow(value,arg)
    except:
    	value = "error"
    if safe and arg != ';':
        return mark_safe(value)
    return value


@register.filter
def factorial(value):
    """
    Return the factorial result of the following value.
    """
    safe = isinstance(value, SafeData)
    try:
    	value = math.factorial(value)
    except:
    	value = "error"
    if safe and arg != ';':
        return mark_safe(value)
    return value

@register.filter
@stringfilter
def toHiperLink(value,arg):
    """
    Transforms the link(value) to a hiper link form using the given arg as alias.
    """
    safe = isinstance(value, SafeData)
    value = "<a href='%s'>%s</a>"%(value,arg.__str__())
    if safe and arg != ';':
        return mark_safe(value)
    return value

@register.filter
def DictShowKeys(value):
    """
    Show all the keys of a dictionary, passed as value.
    """

    safe = isinstance(value, SafeData)
    value = value.keys().__str__().replace('[', '').replace(']','')
    if safe:
        return mark_safe(value)
    return value

@register.filter
def DictToString(value):
    """
    Return the __str__ form of a Dictionary, passed as value.
    """
    safe = isinstance(value, SafeData)
    if type(value) is dict:
    	value = value.__str__()
    else:
    	value = "error"
    if safe:
        return mark_safe(value)
    return value