from django.db import connection
from django.db.models.aggregates import Sum
from django.test import TestCase

from repro.thing.models import Container, Thing


class FilterOnAnnotationTest(TestCase):

    def setUp(self):
        things = [
            Thing.objects.create(cost=1.23),
            Thing.objects.create(cost=4.56),
            Thing.objects.create(cost=7.89),
        ]

        container = Container.objects.create()
        container.things = things
        container.save()

        self.query = Container.objects.annotate(total_cost=Sum('things__cost'))
        self.buggy_query = self.query.filter(total_cost__gt=0)

    def test_can_filter_on_annotation(self):
        self.assertGreater(self.query[0].total_cost, 0)

        self.assertEqual(
            len(self.query),
            len(self.buggy_query),
            ('Filtering on total_cost__gt=0 should return at least one result '
             'since the total_cost of the first item *before* the filter was '
             'applied was greater than 0.')
        )

    def test_can_filter_on_annotation_with_raw_sql(self):
        cursor = connection.cursor()
        raw_sql = str(self.buggy_query.query)
        cursor.execute(raw_sql)
        self.assertEqual(
            len(self.query),
            len(cursor.fetchall()),
        )
        cursor.close()
