from django.db import IntegrityError
from django.test import TestCase
from django.test.utils import override_settings
from django.utils.translation import override

from myauth.models import User

class BasicTestCase(TestCase):
    def test_user_fields(self):
        """
        Tests necessary user fields and names
        """
        with override('en-us'):
            self.assertEqual(unicode(User._meta.verbose_name), 'user')
            self.assertEqual(unicode(User._meta.verbose_name_plural), 'users')

            fields = User.__dict__['_meta'].fields + User.__dict__['_meta'].many_to_many
            fsig = tuple((fi.__class__.__name__,
                          unicode(fi.name),
                          unicode(fi.verbose_name),
                          unicode(fi.help_text)) for fi in fields)
            self.assertEqual(len(fields), 11)
            self.assertEqual(fsig[0], ('AutoField', u'id', u'ID', u''))
            self.assertEqual(fsig[1], ('CharField', u'password', u'password', u''))
            self.assertEqual(fsig[2], ('DateTimeField', u'last_login', u'last login', u''))
            self.assertEqual(fsig[3], ('BooleanField', u'is_superuser', u'superuser status',
                                       u'Designates that this user has all permissions without explicitly assigning them.'))
            self.assertEqual(fsig[4], ('EmailField', u'email', u'email address', u''))
            self.assertEqual(fsig[5], ('CharField', u'full_name', u'full name', u''))
            self.assertEqual(fsig[6], ('BooleanField', u'is_staff', u'staff status',
                                       u'Designates whether the user can log into this admin site.'))
            self.assertEqual(fsig[7], ('BooleanField', u'is_active', u'active',
                                       u'Designates whether this user should be treated as active. Unselect this instead of deleting accounts.'))
            self.assertEqual(fsig[8], ('DateTimeField', u'date_joined', u'date joined', u''))
            self.assertEqual(fsig[9], ('ManyToManyField', u'groups', u'groups',
                                        u'The groups this user belongs to. A user will get all permissions '
                                        'granted to each of his/her group. Hold down "Control", or "Command" on a Mac, to select more than one.'))
            self.assertEqual(fsig[10], ('ManyToManyField', u'user_permissions', u'user permissions',
                                        u'Specific permissions for this user. '
                                        'Hold down "Control", or "Command" on a Mac, to select more than one.'))

    def test_user_email_identity(self):
        """
        Username uniquely identifies user
        """
        self.assertRaisesMessage(ValueError,
                                 'The given email must be set',
                                  User.objects.create_user, None)
        User.objects.create_user('captain.smollett@island.im')
        self.assertRaises(IntegrityError, User.objects.create_user, 'captain.smollett@island.im')
