# coding=utf-8
from django.db import models


class Product(models.Model):
    id = models.AutoField(primary_key=True)
    price = models.IntegerField(db_column='price', default=0)
    type = models.CharField(max_length=50, db_column='type', blank=True, null=True)
    enable = models.BooleanField(default=False, db_column='enable')

    class Meta:
        db_table = 'product'




class DoorStatus(models.Model):
    id = models.AutoField(primary_key=True, db_column='id')

    class Meta:
        db_table = 'door_status'


class Door(Product):
    parent_product = models.OneToOneField(Product, parent_link=True, related_name='door', db_column='parent')
    status = models.ForeignKey(DoorStatus, db_column='door_status')
    price_box = models.IntegerField(null=True, default=0, blank=True, db_column='price_box')
    price_frame = models.IntegerField(null=True, default=0, blank=True, db_column='price_frame')

    class Meta:
        db_table = 'door'
