from django.test import TestCase

from django.db import connection as conn
from django.test.utils import override_settings

from .models import Author, Book

class TestPrefetchRelated(TestCase):
	def setUp(self):
		super(TestPrefetchRelated, self).setUp()
		populate_db(3, 3)
	
	@override_settings(DEBUG = True)
	def test_prefetch_related(self):
		books = list(Book.objects.all().prefetch_related('author'))
		
		author_ids = {
			b.author_id for b in books
			if b.author_id
		}
		
		qs = conn.queries
		self.assertEqual(len(qs), 2)
		
		pq = qs[1]['sql']
		lookup_id_str = pq.split('- PARAMS = ')[1]
		lookup_ids = set(map(int, lookup_id_str[1:-1].split(', ')))
		
		self.assertEqual(author_ids, lookup_ids)

def populate_db(authors, books_per_author):
	for i in xrange(authors):
		author = Author.objects.create(
			name = 'a{:04}'.format(i),
		)
		
		for j in xrange(books_per_author):
			Book.objects.create(
				name = 'a{:04}/b{:04}'.format(i, j),
				author = author,
			)
