from django.db import models

class Author(models.Model):
    name = models.CharField(max_length=120)
    book = models.OneToOneField('Book', null=True, blank=True) 

    def __unicode__(self):
        return self.name

class Reader(models.Model):
    name = models.CharField(max_length=120)
    book = models.OneToOneField('Book', null=True, blank=True) 

    def __unicode__(self):
        return self.name

class Book(models.Model):
    name = models.CharField(max_length=120)

    def __unicode__(self):
        return self.name


class SimpleBook(models.Model):
    name = models.CharField(max_length=120)
    author = models.CharField(max_length=120, null=True, blank=True)
    reader = models.CharField(max_length=120, null=True, blank=True)

    def __unicode__(self):
        return "%s" % self.name
