from django.test import TestCase

from testproject.testapp.models import Book, SimpleBook

class BasicTest(TestCase):

    def test_exclude_query(self):
        qs1 = Book.objects.filter(author=None, reader=None)
        qs2 = Book.objects.exclude(author=None, reader=None)
        self.assertEqual(qs1.count() + qs2.count(), Book.objects.count())

    def test_simple_exclude_query(self):
        qs1 = SimpleBook.objects.filter(author=None, reader=None)
        qs2 = SimpleBook.objects.exclude(author=None, reader=None)
        self.assertEqual(qs1.count() + qs2.count(), SimpleBook.objects.count())
