from django import test
from django.db import models

class Person(models.Model):
    name = models.CharField(max_length=50)
    
class Politician(models.Model):
    politician_id = models.AutoField(primary_key=True)
    title = models.CharField(max_length=50)
    
class Congressman(Person, Politician):
    state = models.CharField(max_length=2)
    
class Senator(Congressman):
    pass

class MultiInheritanceTest(test.TestCase):
    def test_multiple_inheritance(self):
        Politician.objects.create(title='Ms.')
        Person.objects.create(name="A")
        Person.objects.create(name="B")
        Person.objects.create(name="C")
        
        senator = Senator.objects.create(name='John Doe',
                                         title='Maj. Leader',
                                         state='TX')
        
        #print Senator.objects.filter(politician_id=1).query
        
        senator_copy = Senator.objects.get(politician_id=senator.politician_id)
        
        self.assertEqual(senator.pk, senator_copy.pk)