from django.db import models

class MyModel(models.Model):
    a_field = models.TextField()

class MyModel1(models.Model):
    first_name = models.CharField(max_length=200)
    last_name = models.CharField(max_length=200)
    full_name = models.CompositeField(
        first_name, last_name, unique=True)
    selfm2m = models.ManyToManyField('self', symmetrical=True, blank=True)

    def __unicode__(self):
        return u'%s, %s' % (self.last_name, self.first_name)


class MyModel2(models.Model):
    f1 = models.IntegerField()
    f2 = models.IntegerField()
    primary_key = models.CompositeField(f1, f2, primary_key=True)
    mymodel2 = models.ForeignKey(
        MyModel1, null=True, to_field='full_name', on_delete=models.SET_NULL,
        on_update=models.CASCADE
    )

    def __unicode__(self):
        return u'%s, %s' % (self.f1, self.f2)


class MyModel3(models.Model):
    mymodel1set = models.ManyToManyField(MyModel2)


class Country(models.Model):
    name = models.CharField(max_length=20, unique=True)

    def __unicode__(self):
        return self.name

class City(models.Model):
    country = models.ForeignKey(Country, to_field='name', on_update=models.CASCADE)
    name = models.CharField(max_length=20)
    country_city_uq = models.CompositeField(country, name, unique=True)

    def __unicode__(self):
        return "%s, %s" % (self.country_id, self.name)

class Street(models.Model):
    city = models.ForeignKey(City, to_field='country_city_uq', on_update=models.CASCADE)
    name = models.CharField(max_length=20)
    country_city_street_uq = models.CompositeField(city, name, unique=True)

    def __unicode__(self):
        return "%s, %s, %s" % (self.city_country, self.city_name, self.name)
