from functools import wraps, update_wrapper, WRAPPER_ASSIGNMENTS

def method_decorator(decorator):
    """
    Converts a function decorator into a method decorator
    """
    # 'func' is a function at the time it is passed to _dec, but will eventually
    # be a method of the class it is defined it.
    def _dec(func):
        def _wrapper(self, *args, **kwargs):
            @decorator
            def bound_func(*args2, **kwargs2):
                #return func(self, *args2, **kwargs2)
                return func.__get__(self, type(self))(*args2, **kwargs2)
            # bound_func has the signature that 'decorator' expects i.e.  no
            # 'self' argument, but it is a closure over self so it can call
            # 'func' correctly.
            return bound_func(*args, **kwargs)
        # In case 'decorator' adds attributes to the function it decorates, we
        # want to copy those. We don't have access to bound_func in this scope,
        # but we can cheat by using it on a dummy function.
        @decorator
        def dummy(*args, **kwargs):
            pass
        update_wrapper(_wrapper, dummy)
        # Need to preserve any existing attributes of 'func', including the name.
        update_wrapper(_wrapper, func)

        return _wrapper
    update_wrapper(_dec, decorator)
    # Change the name to aid debugging.
    _dec.__name__ = 'method_decorator(%s)' % decorator.__name__
    return _dec

def my_wrapper_1(wrapped):
    def _wrapper(arg1, arg2):
        print('_wrapper', arg1, arg2)
        return wrapped(arg1, arg2)
    return _wrapper

@my_wrapper_1
def function(arg1, arg2):
    print('function', arg1, arg2)
    return arg1, arg2

function(1, 2)

my_method_wrapper_1 = method_decorator(my_wrapper_1)

class my_bound_wrapper_2(object):
    def __init__(self, wrapped):
        self.wrapped = wrapped
        self.__name__ = wrapped.__name__
    def __call__(self, arg1, arg2):
        print('my_bound_wrapper_2.__call__', arg1, arg2)
        return self.wrapped(arg1, arg2)
    def __get__(self, instance, owner):
        print('my_bound_wrapper_2.__get__', instance, owner)
        return self

class my_desc_wrapper_2(object):
    def __init__(self, wrapped):
        self.wrapped = wrapped
        self.__name__ = wrapped.__name__
    def __get__(self, instance, owner):
        print('my_desc_wrapper_2.__get__', instance, owner)
        return my_bound_wrapper_2(self.wrapped.__get__(instance, owner))

class Class(object):

    @my_method_wrapper_1
    def method_1(self, arg1, arg2):
        print('Class.method_1', self, arg1, arg2)
        return arg1, arg2

    @my_desc_wrapper_2
    def method_2(self, arg1, arg2):
        print('Class.method_2', arg1, arg2)
        return arg1, arg2

    @my_method_wrapper_1
    @my_desc_wrapper_2
    def method_3(self, arg1, arg2):
        print('Class.method_3', arg1, arg2)
        return arg1, arg2

    @my_method_wrapper_1
    @my_method_wrapper_1
    def method_4(self, arg1, arg2):
        print('Class.method_4', self, arg1, arg2)
        return arg1, arg2

c = Class()

c.method_1(1, 2)
c.method_2(1, 2)
c.method_3(1, 2)
c.method_4(1, 2)
