#!/usr/bin/env python

import os
os.environ.setdefault('DJANGO_SETTINGS_MODULE', 'bugrep.settings')

import django
from django.db.models import Count
from bugrep.models import *

Alfa.objects.all().delete()
Bravo.objects.all().delete()
Charlie.objects.all().delete()

b = Bravo.objects.create()
c = Charlie.objects.create(bravo=b)

qsboth = Charlie.objects.select_related('alfa').annotate(Count('bravo__charlie'));
print('select_related + annotate: %i rows' % qsboth.count())
print(str(qsboth.query) + '\n')

qsboth_rev = Charlie.objects.annotate(Count('bravo__charlie')).select_related('alfa');
print('annotate + select_related: %i rows' % qsboth_rev.count())
print('identical query? ' + ('yes' if str(qsboth_rev.query) == str(qsboth.query) else 'no') + '\n')

qsselrel = Charlie.objects.select_related('alfa');
print('select_related: %i rows' % qsselrel.count())
print(str(qsselrel.query) + '\n')

qsanno = Charlie.objects.annotate(Count('bravo__charlie'));
print('annotate: %i rows' % qsanno.count() + '\n')

print('Trying with non-null alfa\n')

a = Alfa.objects.create()
Charlie.objects.update(alfa=a)

qsboth_nn = Charlie.objects.select_related('alfa').annotate(Count('bravo__charlie'));
print('select_related + annotate: %i rows' % qsboth_nn.count())
print('identical query? ' + ('yes' if str(qsboth_nn.query) == str(qsboth.query) else 'no') + '\n')

qsboth_nn_rev = Charlie.objects.annotate(Count('bravo__charlie')).select_related('alfa');
print('annotate + select_related: %i rows' % qsboth_nn_rev.count())
print('identical query? ' + ('yes' if str(qsboth_nn_rev.query) == str(qsboth.query) else 'no') + '\n')

print('Django version: ' + django.get_version())
