from django.contrib import admin

from .models import Machine, Software

class SoftInline(admin.TabularInline):
    model = Software
    max_num = 2000
    extra = 3

    def has_add_permission(self, request):
        return False


class MachineAdmin(admin.ModelAdmin):
    inlines = [SoftInline,]


admin.site.register(Machine, MachineAdmin)
