import datetime
import memcache

class SessionLoaderImpl:
    def __init__(self):
        self._mc = memcache.Client(['localhost:11211'])

    def load(self, session_key):
        session_data = self._mc.get(session_key)
        if not session_data:
            return None
        return Session(session_key, session_data)

    def save(self, session_key, session_data, expire_seconds):
        s = Session(session_key, session_data)
        if session_data:
            self._mc.set(session_key, session_data, expire_seconds)
        else:
            self._mc.delete(session_key) # Clear sessions with no data.
        return s

class Session:
    session_key = None
    session_data = None

    def __init__(self, key, data):
        self.session_key  = key
        self.session_data = data
