import datetime
from django.db import models
from django.utils.translation import gettext_lazy as _

class SessionLoaderImpl:
    def load(self, session_key):
        try:
            return Session.objects.get(session_key=session_key, expire_date__gt=datetime.datetime.now())
        except:
            return None

    def save(self, session_key, session_data, expire_seconds):
        expire_date = datetime.datetime.now() + datetime.timedelta(seconds=expire_seconds)
        s = Session(session_key, session_data, expire_date)
        if session_data:
            s.save()
        else:
            s.delete() # Clear sessions with no data.
        return s

class Session(models.Model):
    session_key = models.CharField(_('session key'), maxlength=40, primary_key=True)
    session_data = models.TextField(_('session data'))
    expire_date = models.DateTimeField(_('expire date'))
    class Meta:
        db_table = 'django_session'
        verbose_name = _('session')
        verbose_name_plural = _('sessions')
