class Manager(models.Manager):
    """Provides the update_or_create method for regular managers.

    This will call get_or_create, and if an object is not created, it
    will update the object with the contents of the defaults parameter
    and save it."""

    def update_or_create(self, **kwargs):
        obj, created = self.get_or_create(**kwargs)
        if not created and "defaults" in kwargs:
            for k, v in kwargs.get("defaults", {}).items():
                if k not in dir(obj):
                    raise AttributeError("Invalid attribute %s provided for update on %s (%d)" % (k, type(obj), obj.pk))

                setattr(obj, k, v)
            obj.save()

        return obj, created
