# coding: utf-8
import django.db.transaction
from django.test.testcases import TestCase
from django.test.testcases import TransactionTestCase

ORIGINAL = django.db.transaction.enter_transaction_management


class TransactionCheckMixin(object):
    def test_transaction_method(self):
        self.assertEqual(ORIGINAL, django.db.transaction.enter_transaction_management)


class Before(TransactionCheckMixin, TransactionTestCase):
    pass


class Broken(TestCase):
    fixtures = ['broken_fixture']

    def test_something(self):
        self.assertTrue(True)  # will not happen


class After(TransactionCheckMixin, TransactionTestCase):
    pass
