# This dictionary maps Field objects to their associated MySQL column
# types, as strings. Column-type strings can contain format strings; they'll
# be interpolated against the values of Field.__dict__ before being output.
# If a column type is set to None, it won't be included in the output.
DATA_TYPES = {
    'AutoField':         'number(38)',
    'BooleanField':      'number(1)',
    'CharField':         'varchar2(%(maxlength)s)',
    'CommaSeparatedIntegerField': 'varchar2(%(maxlength)s)',
    'DateField':         'date',
    'DateTimeField':     'date',
    'EmailField':        'varchar2(75)',
    'FileField':         'varchar2(100)',
    'FloatField':        'number(%(max_digits)s, %(decimal_places)s)',
    'ImageField':        'varchar2(100)',
    'IntegerField':      'integer',
    'IPAddressField':    'char(15)',
    'ManyToManyField':   None,
    'NullBooleanField':  'integer',
    'OneToOneField':     'integer',
    'PhoneNumberField':  'varchar(20)',
    'PositiveIntegerField': 'integer',
    'PositiveSmallIntegerField': 'smallint',
    'SlugField':         'varchar(50)',
    'SmallIntegerField': 'smallint',
    'SmallTextField':    'varchar2(4000)',
    'TextField':         'long',
    'TimeField':         'timestamp',
    'URLField':          'varchar(200)',
    'USStateField':      'varchar(2)',
    'XMLField':          'long',
}
