import os
os.environ['DJANGO_SETTINGS_MODULE'] = 'settings'

from django.db import transaction
import gc
from leaks.models import Foo

@transaction.commit_on_success
def delete():
    for obj in Foo.objects.all():
        obj.delete()
delete()

@transaction.commit_on_success
def create_foos():
    for i in range(0, 101):
        Foo.objects.create()
create_foos()

gc.collect()
print(gc.garbage)
bool(Foo.objects.all())
gc.collect()
print(gc.garbage)
