from django.contrib.auth.models import User
from django.contrib.admin.tests import AdminSeleniumWebDriverTestCase
from .models import Author, Book

class TestsForTicket19888(AdminSeleniumWebDriverTestCase):
    def setUp(self):
        # setup superuser
        suname = "admin"
        sumail = "admin@example.com"
        supass = "admin"
        
        User.objects.create_superuser(suname, sumail, supass)
        
        # login to admin
        self.admin_login("admin", "admin")
        
        # create author
        self.seuss = Author.objects.create(name="Dr. Seuss")
        self.seuss.save()
        
        # this should be contained in the result page on a successful submission
        self.searchstr = 'The author "%s" was changed successfully.' % self.seuss.name
        
        self.submission_url = self.live_server_url + '/admin/test_app/author/%s/' % self.seuss.pk
        
        self.title_id = 'id_book_set-0-title'
        
        
    def test_save(self):
        # ensure that there are no other issues by attempting a submission to the author
        # that should be successful
        self.selenium.get(self.submission_url)
        
        self.wait_page_loaded()
        
        title = self.selenium.find_element_by_id(self.title_id)
        title.submit()
        
        self.wait_page_loaded()
        
        lis = self.selenium.find_elements_by_tag_name('li')
        
        lis_texts = [li.text for li in lis]
        
        self.assertIn(self.searchstr, lis_texts)
    
    def test_inline_save(self):
        # now repeat the submission, but attempt to cause the MultiValueDictKeyError
        lorax = Book.objects.create(author=self.seuss, title="The Lorax")
        lorax.save()
        
        self.selenium.get(self.submission_url)
        
        self.wait_page_loaded()
        
        title = self.selenium.find_element_by_id(self.title_id)
        title.submit()
        
        self.wait_page_loaded()
        
        lis = self.selenium.find_elements_by_tag_name('li')
        
        lis_texts = [li.text for li in lis]
        
        self.assertIn(self.searchstr, lis_texts)