from django.db import models
from django.template.defaultfilters import slugify
 
class Author(models.Model):
    name = models.CharField(max_length=200)
 
    def __unicode__(self):
        return self.name
 
class Book(models.Model):
    author = models.ForeignKey(Author)
    slug = models.SlugField(primary_key=True)
    title = models.CharField(max_length=200)
 
    def __unicode__(self):
        return self.title
 
    def save(self, **kwargs):
        if not self.slug:
            self.slug = slugify(self.title)
        super(Book, self).save(**kwargs)