# vim: set ts=8 sw=4 sts=4 et ai tw=79:
from django.contrib.auth.hashers import BasePasswordHasher


class NoAlgorithmHasher(BasePasswordHasher):
    """
    Don't do any password creation. Just make sure the (empty) algorithm is
    caught when traversing the PASSWORD_HASHERS list.

    Normal Django passwords look like this:

        sha1$e8ca1$15bc9...

    md5crypt passwords look like this:

        $1$zwoKw2$fE8jKx...

    The password hashing algorithm is taken from the first string before the
    dollar sign. This is the empty string in this case.

    By default that yields the following error when the Django built-in auth
    traverses the PASSWORD_HASHERS list:

        ValueError: Unknown password hashing algorithm ''. Did you specify it
        in the PASSWORD_HASHERS setting?

    This handles things by always returning false. The other
    AUTHENTICATION_BACKEND already checked the md5crypt password style, so
    we're done here.
    """
    algorithm = ''

    def verify(self, password, encoded):
        return False
