# -*- coding: UTF-8 -*-
from django.db import models

from django.contrib.auth.models import AbstractBaseUser, BaseUserManager

# Create your models here.
class MyUserManager(BaseUserManager):
    def create_user(self, cusername, password=None):
        """
        Creates and saves a User with the given email, date of
        birth and password.
        """

        user = self.model(cusername=cusername,
        )

        user.set_password(password)
        user.save(using=self._db)
        return user

    def create_superuser(self, cusername, password):
        """
        Creates and saves a superuser with the given email, date of
        birth and password.
        """
        user = self.model(cusername=cusername,
        )
        user.is_admin = True
        user.save(using=self._db)
        return user

class MyUser(AbstractBaseUser):
    cusername = models.CharField(max_length=30, verbose_name='uživatel')

    objects = MyUserManager()

    USERNAME_FIELD = 'cusername'

