from django.contrib import admin
from core.models import EntertainmentPhoto, Entertainment, EntertainmentType, ServiceProvider

class EntertainmentTypeAdmin(admin.ModelAdmin):
    pass

class EntertainmentPhotoInline(admin.TabularInline):
    model = EntertainmentPhoto

class EntertainmentAdmin(admin.ModelAdmin):
    filter_horizontal = ["types"]
    list_filter = ["provider", "types", ]
    inlines = [EntertainmentPhotoInline]

admin.site.register(Entertainment, EntertainmentAdmin)
admin.site.register(ServiceProvider)
admin.site.register(EntertainmentType, EntertainmentTypeAdmin)