import os
from unittest import TestCase
os.environ.setdefault('DJANGO_SETTINGS_MODULE', __name__)

from django import forms
from django.db import models
from django.utils import timezone
from django.test.client import RequestFactory
from django.test.utils import override_settings


class DummyForm(forms.Form):
    value = forms.DateTimeField()


class DummyModel(models.Model):
    class Meta:
        app_label = 'tzbug'

    value = models.DateTimeField()


class DummyModelForm(forms.ModelForm):
    class Meta:
        model = DummyModel


class TimezonesBugTestCase(TestCase):

    def setUp(self):
        self.factory = RequestFactory()

    @override_settings(USE_TZ=True, TIME_ZONE='Europe/Bucharest')
    def test_aware_datetime_with_form(self):
        value = timezone.now()
        request = self.factory.post('/', data={'value': value.isoformat(' ')})
        form = DummyForm(request.POST)

        self.assertTrue(form.is_valid())
        self.assertEquals(value, form.cleaned_data['value'])

    @override_settings(USE_TZ=True, TIME_ZONE='Europe/Bucharest')
    def test_aware_datetime_with_modelform(self):
        value = timezone.now()
        request = self.factory.post('/', data={'value': value.isoformat(' ')})
        form = DummyModelForm(request.POST)

        self.assertTrue(form.is_valid())
        self.assertEquals(value, form.cleaned_data.get('value'))

    @override_settings(USE_TZ=False)
    def test_works_ok_with_use_tz_off(self):
        value = timezone.now()
        request = self.factory.post('/', data={'value': value.isoformat(' ')})
        form = DummyModelForm(request.POST)

        self.assertTrue(form.is_valid())
        self.assertEquals(value, form.cleaned_data.get('value'))
        


if __name__ == '__main__':
    import unittest
    unittest.main()