from django.utils.text import truncate_words

import re
re_space = re.compile(r'(?:^\s+)?\S+\s*')
def new_truncate_words(s, num):
    "Truncates a string after a certain number of words." 
    length = int(num) 
    words = [] 
    for count, match in enumerate(re_space.finditer(s)): 
        if count >= length:   # count is 0-based 
            if words: 
                last_word = words[-1].rstrip() 
                words[-1] = last_word 
                if not last_word.endswith('...'): 
                    words.append(' ...') 
            break 
        words.append(match.group()) 
    return ''.join(words)


import time

loop = range(100000)
short = 'test    me    out    now'
longer = '''Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Pellentesque eget lacus non leo euismod accumsan. Ut lorem. Curabitur vehicula egestas enim. Nunc pretium egestas orci. Donec est dolor, luctus et, condimentum in, luctus non, nibh. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Etiam ultricies tempus ligula. Morbi vitae enim. Nunc pulvinar gravida purus. Duis lorem nulla, hendrerit sit amet, sollicitudin vel, accumsan non, leo. Maecenas eleifend nisl eu turpis. Praesent tempus neque sit amet metus. Vivamus auctor quam vitae metus fringilla placerat. Proin tincidunt lacus id leo.

Curabitur eget nulla quis massa interdum tristique. Maecenas metus mauris, interdum id, consectetuer et, sollicitudin sit amet, lectus. Duis commodo pede vitae neque. Cras ut ligula in massa feugiat ultrices. In consectetuer risus at nibh. Pellentesque eget purus. Vivamus porta dapibus massa. Quisque et enim. Nunc cursus enim eu nibh. Cras iaculis, lacus quis consectetuer interdum, turpis orci dapibus neque, ac pellentesque nisi elit at ante. Etiam faucibus. Mauris dolor. Vivamus id quam ut sapien porta ornare. Maecenas arcu est, pharetra et, ornare quis, sodales ac, ante.'''

print 'truncate_words:    ', truncate_words(short, 3)
print 'new_truncate_words:', new_truncate_words(short, 3)

start = time.clock()
for i in loop:
    truncate_words(short, 3)
print 'short truncate_words    ', time.clock() - start

start = time.clock()
for i in loop:
    new_truncate_words(short, 3)
print 'short new_truncate_words', time.clock() - start


start = time.clock()
for i in loop:
    truncate_words(longer, 3)
print 'long  truncate_words    ', time.clock() - start

start = time.clock()
for i in loop:
    new_truncate_words(longer, 3)
print 'long  new_truncate_words', time.clock() - start
