#
# Extend WizardView w/o patching Django
#

class SessionWizardView(SessionWizardView):
    class RevalidationError(Exception):
        def __init__(self, step, form, **kwargs):
            self.step = step
            self.form = form
            self.kwargs = kwargs

        def __repr__(self):
            return '%s(%s)' % (self.__class__, self.step)
        __str__ = __repr__

    def render_done(self, form, **kwargs):
        """See ticket #19189"""
        try:
            done_response = super(SessionWizardView, self).render_done(form, **kwargs)
        except self.RevalidationError as e:
            return self.render_revalidation_failure(e.step, e.form, **e.kwargs)
        return done_response

    def get_context_data(self, form, **kwargs):
        """See ticket #19025"""
        context = super(SessionWizardView, self).get_context_data(form, **kwargs)
        context['form'] = form
        return context


