from django.contrib.gis import geos
from django.contrib.gis import gdal

a = geos.Point(1, 2, srid=4326)
print 'WGS84:', a.coords
w2c = gdal.CoordTransform(gdal.SpatialReference(4326),
                          gdal.SpatialReference('+proj=mill +lat_0=0 +lon_0=0 +x_0=0 +y_0=0 +R_A +ellps=WGS84 +datum=WGS84 +units=m +no_defs'))
b = a.transform(w2c, clone=True)
b.srid = 999999 # crash if correct SRID
#b.srid = 4326   # success if bogus SRID
print 'custom:', b.coords
c2w = gdal.CoordTransform(gdal.SpatialReference('+proj=mill +lat_0=0 +lon_0=0 +x_0=0 +y_0=0 +R_A +ellps=WGS84 +datum=WGS84 +units=m +no_defs'),
                          gdal.SpatialReference(4326))
c = b.transform(c2w, clone=True)
print 'back to WGS84', c.coords
