#!/usr/bin/env python3
# -*- coding: utf-8 -*-

from django.shortcuts import render_to_response
from django.views.decorators.csrf import csrf_protect
from django.template import RequestContext

from foo.forms import TestForm


def testrequest(request):
    items = sorted(request.META.items())
    return render_to_response('testrequest.html', {'items': items, 'kekse': request.COOKIES.items(), 'encoding': request.encoding})
    
@csrf_protect    
def formtest(request):
    form = TestForm(request.POST)
    form.is_valid()
    try:
        Text = form.cleaned_data['Text']
    except:
        Text = 'FAIL'
    return render_to_response('formtest.html', {'form': form, 'Text': Text}, context_instance=RequestContext(request))