# Create your views here.
from django.shortcuts import render, get_object_or_404, redirect
from Sandbox_App.forms import ConversationForm
from django.http import HttpResponseRedirect
import datetime
from Sandbox_App.models import Conversation
import pytz
from django.utils import timezone
from Sandbox.formats.en import formats as formats_en
from Sandbox.formats.en_GB import formats as formats_en_GB
from django.utils.timezone import utc


def set_timezone(request):
    if request.method == 'POST':
        request.session['django_timezone'] = pytz.timezone(request.POST['timezone'])
        return redirect(request.path)
    else:
        return redirect('/')

def display_current_language(request):
    if request.LANGUAGE_CODE == 'en-gb':
        lang = "British English"        
    elif request.LANGUAGE_CODE == 'en':        
        lang = "American English"           
    return lang

def get_current_format(request):
    if request.LANGUAGE_CODE == 'en-gb':
        return formats_en_GB.DATE_INPUT_FORMATS[0]
    elif request.LANGUAGE_CODE == 'en':        
        return formats_en.DATE_INPUT_FORMATS[0]

def get_current_timeformat(request):
    if request.LANGUAGE_CODE == 'en-gb':
        return formats_en_GB.TIME_INPUT_FORMATS[0]
    elif request.LANGUAGE_CODE == 'en':        
        return formats_en.TIME_INPUT_FORMATS[0]

def get_current_datetimeformat(request):
    if request.LANGUAGE_CODE == 'en-gb':
        return formats_en_GB.DATETIME_INPUT_FORMATS[0]
    elif request.LANGUAGE_CODE == 'en':        
        return formats_en.DATETIME_INPUT_FORMATS[0]


def my_view(request):        
    conversations = Conversation.objects.all()        
    lang = display_current_language(request)
    variables = {'conversations':conversations, 'lang':lang, 'timezones': pytz.common_timezones}    
    return render(request, 'main_page.html', variables)



def add_view(request, conversation_id=None):     
    lang = display_current_language(request)
    
    if conversation_id is None:
        c = Conversation(conversation_datetime=timezone.now())        
    else:
        c = get_object_or_404(Conversation.objects.all(), pk=conversation_id)        
    if request.method == 'POST':
        form = ConversationForm(request.POST, instance=c)
        if form.is_valid():               
            conversation = form.save(commit=False)
            current_tz = timezone.get_current_timezone()            
            date = form.cleaned_data['conversation_date']
            time = form.cleaned_data['conversation_time']            
            date_time = current_tz.localize(datetime.datetime(date.year, date.month, date.day, time.hour, time.minute))                        
            conversation.conversation_datetime = date_time
            conversation.save()
            return HttpResponseRedirect('/')
    else:
        form = ConversationForm(instance=c)    
    variables = {'form':form, 'lang':lang, 'timezones': pytz.common_timezones}    
    return render(request, 'conversation.html', variables)