from django.forms.models import ModelForm
from Sandbox_App.models import Conversation
from django import forms
from django.utils import timezone
import pytz

class ConversationForm(ModelForm):
    conversation_date = forms.DateField(localize=True, widget=forms.DateInput())
    conversation_time = forms.TimeField(localize=True, widget=forms.TimeInput())
    
    def __init__(self, *args, **kwargs):
        super(ConversationForm, self).__init__(*args, **kwargs)        
        local_tz = timezone.get_current_timezone()
        self.fields['conversation_date'].initial = self.instance.conversation_datetime.replace(tzinfo=pytz.utc).astimezone(local_tz).date()
        self.fields['conversation_time'].initial = self.instance.conversation_datetime.replace(tzinfo=pytz.utc).astimezone(local_tz).time()  
    
    class Meta:
        model = Conversation 
        exclude = ('conversation_datetime')