from django.core import serializers
from django.test import TestCase
from django.contrib.auth.models import User
import json

class Subuser(User):
    pass

class SerializeSubModelTest(TestCase):
    
    def setUp(self):
        Subuser.objects.create(username="sina")

    def test_serializer(self):
        object_list = Subuser.objects.all()
        jsonstr = serializers.serialize('json', object_list, ensure_ascii=False)
        print(jsonstr) # got '[{"pk": 1, "model": "tta.subuser", "fields": {"user_permissions": [], "groups": []}}]'
        data = json.loads(jsonstr)
        self.assertEqual('sina', data[0]['fields']['username'])