# Create your views here.
from django.shortcuts import render, get_object_or_404
from Sandbox_App.models import Company
from Sandbox_App.forms import CompanyForm
from django.http import HttpResponseRedirect
import datetime

def display_current_language(request):
    if request.LANGUAGE_CODE == 'en-gb':
        lang = "You prefer to read British English."
    else:
        lang = "You prefer to read American English."
    return lang

def my_view(request):        
    companies = Company.objects.all()        
    lang = display_current_language(request)
    variables = {'companies':companies, 'lang':lang}    
    return render(request, 'main_page.html', variables)



def add_view(request, company_id=None):     
    lang = display_current_language(request)
    
    if company_id is None:
        c = Company(date=datetime.datetime.now(), time=datetime.datetime.now())        
    else:
        c = get_object_or_404(Company.objects.all(), pk=company_id)        
    if request.method == 'POST':
        form = CompanyForm(request.POST, instance=c)
        if form.is_valid():
            form.save()
            return HttpResponseRedirect('/')
    else:
        form = CompanyForm(instance=c)    
    variables = {'form':form, 'lang':lang}    
    return render(request, 'company.html', variables)