from django import forms
from django.test import TestCase
from django.utils import translation
from django.core.exceptions import ValidationError


class LocalizationTests(TestCase):
        def test_localization(self):
            with translation.override('es'):
                with self.settings(USE_L10N=True):
                    #Non Localized Field
                    non_localized_field = forms.DecimalField(localize=False)
                    with self.assertRaises(ValidationError):
                        non_localized_field.to_python("234,23")
    
                    #Localized Decimal Field
                    localized_field = forms.DecimalField(localize=True)
                    with self.assertRaises(ValidationError):
                        localized_field.to_python("234.23")
