from django import forms

class FieldWithClassWidget(forms.Field):
  
  def __init__(self,*args,**kwargs):
    super(FieldWithClassWidget,self).__init__(*args,**kwargs)
    
    # Accept other required kwargs...
    
    self.widget = kwargs['widget'] if 'widget' in kwargs else forms.Textarea
    
class FieldWithObjectWidget(forms.Field):
  
  def __init__(self,*args,**kwargs):
    super(FieldWithObjectWidget,self).__init__(*args,**kwargs)
    
    # Accept other required kwargs...
    
    self.widget = kwargs['widget'] if 'widget' in kwargs else forms.Textarea()
    
class FormWithClassWidget(forms.Form):
  
  field = FieldWithClassWidget()
  
class FormWithObjectWidget(forms.Form):
  
  field = FieldWithObjectWidget()
