diff --git a/tests/regressiontests/i18n/commands/extraction.py b/tests/regressiontests/i18n/commands/extraction.py
index fb9ca4e..87e2332 100644
--- a/tests/regressiontests/i18n/commands/extraction.py
+++ b/tests/regressiontests/i18n/commands/extraction.py
@@ -148,6 +148,21 @@ class BasicExtractorTests(ExtractorTests):
             self.assertTrue('msgctxt "Special blocktrans context #4"' in po_contents)
             self.assertTrue("Translatable literal #8d" in po_contents)
 
+    def test_template_message_context_extractor_same_string(self):
+        """
+        Refs #18114.
+        """
+        os.chdir(self.test_dir)
+        management.call_command('makemessages', locale=LOCALE, verbosity=0)
+        self.assertTrue(os.path.exists(self.PO_FILE))
+        with open(self.PO_FILE, 'r') as fp:
+            po_contents = fp.read()
+            print po_contents
+            # {% trans %}
+            self.assertTrue("Translatable literal #9" in po_contents)
+            self.assertTrue('msgctxt "Special trans context #9a"' in po_contents)
+            self.assertTrue('msgctxt "Special trans context #9b"' in po_contents)
+
 class JavascriptExtractorTests(ExtractorTests):
 
     PO_FILE='locale/%s/LC_MESSAGES/djangojs.po' % LOCALE
diff --git a/tests/regressiontests/i18n/commands/templates/test.html b/tests/regressiontests/i18n/commands/templates/test.html
index 5789346..2828282 100644
--- a/tests/regressiontests/i18n/commands/templates/test.html
+++ b/tests/regressiontests/i18n/commands/templates/test.html
@@ -77,3 +77,7 @@ continued here.{% endcomment %}
 {% trans "Shouldn't double escape this sequence %% either" context "ctx1" %}
 {% trans "Looks like a str fmt spec %s but shouldn't be interpreted as such" %}
 {% trans "Looks like a str fmt spec % o but shouldn't be interpreted as such" %}
+
+{% trans "Translatable literal #9" %}
+{% trans "Translatable literal #9" context "Special trans context #9a" %}
+{% trans "Translatable literal #9" as var context "Special trans context #9b" %}
