from django.db import models

class Member(models.Model):
    name = models.CharField(max_length=200, unique=True)

    def save(self, *args, **kwargs):
        super(Member, self).save(*args, **kwargs)

    def __unicode__(self):
        return self.name


from django.contrib import admin

class MemberAdmin(admin.ModelAdmin):
    list_display = ('pk', 'name')
    list_editable = ('name',)
    list_per_page = 2

admin.site.register(Member, MemberAdmin)

