# -*- coding: cp1251 -*-

import re
"""
# https://github.com/django/django/blob/master/django/core/validators.py#L161
# Original incorrect rexexp:

email_re = re.compile(
    r"(^[-!#$%&'*+/=?^_`{}|~0-9A-Z]+(\.[-!#$%&'*+/=?^_`{}|~0-9A-Z]+)*"  # dot-atom
    r'|^"([\001-\010\013\014\016-\037!#-\[\]-\177]|\\[\001-011\013\014\016-\177])*"' # quoted-string
    r')@((?:[A-Z0-9](?:[A-Z0-9-]{0,61}[A-Z0-9])?\.)+[A-Z]{2,6}\.?$)'  # domain
    r'|\[(25[0-5]|2[0-4]\d|[0-1]?\d?\d)(\.(25[0-5]|2[0-4]\d|[0-1]?\d?\d)){3}\]$', re.IGNORECASE)  # literal form, ipv4 address (SMTP 4.1.3)
"""

# Correct regexp
email_re = re.compile(
    r"(^[-!#$%&'*+/=?^_`{}|~0-9A-Z]+(\.[-!#$%&'*+/=?^_`{}|~0-9A-Z]+)*"  # dot-atom
    r'|^"([\001-\010\013\014\016-\037!#-\[\]-\177]|\\[\001-011\013\014\016-\177])*"' # quoted-string
    r')@(((?:[A-Z0-9](?:[A-Z0-9-]{0,61}[A-Z0-9])?\.)+[A-Z]{2,6}\.?$)'  # domain
    r'|(25[0-5]|2[0-4]\d|[0-1]?\d?\d)(\.(25[0-5]|2[0-4]\d|[0-1]?\d?\d)){3}$)', re.IGNORECASE)  # literal form, ipv4 address (SMTP 4.1.3)



mails = [
"vadim@example.com",
"vadim@example_com",
"vadim@127.0.0.1",
"vadim@192.168.1.106",
"vadim@localhost",
"vadim@localhost.localdomain",
"user_name@123.123.123.12"]

for i in mails:
    m = re.match(email_re, i)
    print i, "."*5,
    if m:
        print "matched"
    else:
        print "non-matched"

    
"""
Incorrect:
vadim@example.com ..... matched
vadim@example_com ..... non-matched
vadim@127.0.0.1 ..... non-matched
vadim@192.168.1.106 ..... non-matched
vadim@localhost ..... non-matched
vadim@localhost.localdomain ..... non-matched
user_name@123.123.123.12 ..... non-matched

Correct:
vadim@example.com ..... matched
vadim@example_com ..... non-matched
vadim@127.0.0.1 ..... matched
vadim@192.168.1.106 ..... matched
vadim@localhost ..... non-matched
vadim@localhost.localdomain ..... non-matched
user_name@123.123.123.12 ..... matched
"""

