from django.db import models
from fields import UUIDField

class Worker(models.Model):
    id = UUIDField(primary_key=True)
    name = models.CharField(blank=True, max_length=100)
    def __unicode__(self):
        return u"worker id is %s"%self.pk

class Task(models.Model):
    id = UUIDField(primary_key=True)
    description = models.CharField(blank=True, max_length=100)
    workers = models.ManyToManyField(Worker, through="Todo")
    def __unicode__(self):
        return u"task id is %s"%self.pk

class Todo(models.Model):
    id = UUIDField(primary_key=True)
    worker = models.ForeignKey(Worker)
    task = models.ForeignKey(Task)
    def __unicode__(self):
        return u"todo id is %s"%self.pk
    
class RelatedTester(models.Model):
    id = UUIDField(primary_key=True)
    many = models.ManyToManyField(Worker,related_name='m2mforrelatedtester')
    one = models.OneToOneField(Worker)
    
class ManyTester(models.Model):
    id = UUIDField(primary_key=True)
    many = models.ManyToManyField(Worker,related_name='m2mforManyTester')
    
class OneTester(models.Model):
    id = UUIDField(primary_key=True)
    one = models.OneToOneField(Worker)