from django.contrib import admin
from models import Worker, Task, Todo, RelatedTester, ManyTester, OneTester

class WorkerAdmin(admin.ModelAdmin):
    pass

class TodoInline(admin.TabularInline):
    model = Todo
    fk_name = 'task'
    raw_id_fields = ('worker',)
    extra = 1
    
class TaskAdmin(admin.ModelAdmin):
    inlines = (TodoInline,)

admin.site.register(Worker,WorkerAdmin)
admin.site.register(Task,TaskAdmin)
admin.site.register(RelatedTester)
admin.site.register(ManyTester)
admin.site.register(OneTester)