from django.test import TestCase
from django.contrib.auth.models import User
from django.http import HttpResponse

from re import search,DOTALL

from models import A,B,C,D,E,F

class TestsFor17122(TestCase):
    def setUp(self):
        # create the admin user
        user = User()
        user.username = "admin"
        user.set_password("admin")
        user.is_staff = True
        user.is_superuser = True
        user.save()
        
        # log in
        result = self.client.login(username="admin", password="admin")
        self.assertEqual(result, True)
        
        # create instances to work with
        a1 = A()
        a2 = A()
        a3 = A()
        a1.save()
        a2.save()
        a3.save()
        self.a1 = a1
        self.a2 = a2
        self.a3 = a3
        
        # create foreign keys to test
        b1 = B(relation=a1)
        b2 = B(relation=a2)
        b3 = B(relation=a3)
        b1.save()
        b2.save()
        b3.save()
        self.b1 = b1
        self.b2 = b2
        self.b3 = b3
        
        # create one to ones for testing
        c1 = C(relation=a1)
        c1.save()
        self.c1 = c1

        # create many to manys for testing
        d1 = D()
        d1.save()
        d1.relation.add(a1)
        d1.relation.add(a2)
        d1.save()
        self.d1 = d1
        
        # create relation for inline
        e1 = E()
        e1.save()
        self.e1 = e1
        
    def tearDown(self):
        self.client.logout()
        
    def test_ForeignKey_render(self):
        response = self.client.get(self.b1.get_change_url())
        self.assertContains(response,
            '<option value="%s" selected="selected">%s</option>' % (
                    self.b1.relation.pk,
                    self.b1.relation
            )
        )
        for a in A.objects.all().exclude(pk=self.b1.relation.pk):
            self.assertContains(response,
                '<option value="%s">%s</option>' % (
                        a.pk,
                        a
                )
            )
    
    def test_OneToOneField_render(self):
        response = self.client.get(self.c1.get_change_url())
        self.assertContains(response,
            '<option value="%s" selected="selected">%s</option>' % (
                    self.c1.relation.pk,
                    self.c1.relation
            )
        )
        for a in A.objects.all().exclude(pk=self.c1.relation.pk):
            self.assertContains(response,
                '<option value="%s">%s</option>' % (
                        a.pk,
                        a
                )
            )
    
    def test_ManyToManyField_render(self):
        response = self.client.get(self.d1.get_change_url())
        others = A.objects.all()
        for a in self.d1.relation.all():
            self.assertContains(response,
                '<option value="%s" selected="selected">%s</option>' % (
                        a.pk,
                        a
                )
            )
            others = others.exclude(pk=a.pk)
        for a in others:
            self.assertContains(response,
                '<option value="%s">%s</option>' % (
                        a.pk,
                        a
                )
            )
            
    def test_inline_render(self):
        # create inline
        f1 = F()
        f1.fk1 = self.e1
        f1.fk2 = self.a1
        f1.one1 = self.b1
        f1.save()
        f1.m2m1.add(self.a1)
        f1.m2m1.add(self.a2)
        f1.save()
        
        # query the admin
        response = self.client.get(self.e1.get_change_url())
        text = '<input type="hidden" name="f_set-__prefix__-fk1" value="%s" id="id_f_set-__prefix__-fk1" />' % f1.fk1.pk
        self.assertContains(response, text)
        
        # If the response supports deferred rendering and hasn't been rendered
        # yet, then ensure that it does get rendered before proceeding further.
        if (hasattr(response, 'render') and callable(response.render)
            and not response.is_rendered):
            response.render()
        content = response.content
        
        # create a dict for the parse
        results = {}
        
        # parse response content
        for field_name in ['fk2','one1','m2m1']:
            result = search(
                    r'<select.*?name="f_set-0-%s".*?>(?P<%s>.*?)</select>'%(
                            field_name,
                            field_name
                    ),
                    content,
                    DOTALL
            )
            self.assertIsNotNone(result)
            result = result.groups(field_name)
            self.assertEqual(len(result),1)
            results[field_name] = result[0]
        
        # verify fk2
        response = HttpResponse(results["fk2"])
        self.assertContains(response,
            '<option value="%s" selected="selected">%s</option>' % (
                    f1.fk2.pk,
                    f1.fk2
            )
        )
        for a in A.objects.all().exclude(pk=f1.fk2.pk):
            self.assertContains(response,
                '<option value="%s">%s</option>' % (
                        a.pk,
                        a
                )
            )

        # verify one1 --> NOTE THIS FIELD POINTS TO B INSTEAD OF A
        response = HttpResponse(results["one1"])
        self.assertContains(response,
            '<option value="%s" selected="selected">%s</option>' % (
                    f1.one1.pk,
                    f1.one1
            )
        )
        for b in B.objects.all().exclude(pk=f1.one1.pk):
            self.assertContains(response,
                '<option value="%s">%s</option>' % (
                        b.pk,
                        b
                )
            )
            
        # verify m2m1
        response = HttpResponse(results["m2m1"])
        others = A.objects.all()
        for a in f1.m2m1.all():
            self.assertContains(response,
                '<option value="%s" selected="selected">%s</option>' % (
                        a.pk,
                        a
                )
            )
            others = others.exclude(pk=a.pk)
        for a in others:
            self.assertContains(response,
                '<option value="%s">%s</option>' % (
                        a.pk,
                        a
                )
            )