from django.db import models
from django.core import serializers


class TestField(models.TextField):
    def get_attname(self):
        return '%s_attr' % self.name

class TestModel(models.Model):
    test = TestField()



TestModel(test='blah')
# TypeError: 'test' is an invalid keyword argument for this function

TestModel(test_attr='blah')
# <TestModel: TestModel object>


test = TestModel(test_attr='blah')
json = serializers.serialize('json', [test])
# OK
# json == '[{"pk": null, "model": "testapp.testmodel", "fields": {"test": "blah"}}]'

[obj for obj in serializers.deserialize('json', json)]
# TypeError: 'test' is an invalid keyword argument for this function